/******************************************************************************
 * File     :  OneWireDS1820.c
 * Purpose  :  1-Wire Bus (DS1820 - Temperature digital)
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)

#include <touch.c>            // Module function for 1-wire bus


/***********************************************************************
 * FUNCTION:     ReadTemp_DS1820
 * DESCRIPTION:  Read Temperature
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void ReadTemp_DS1820(void) {
   byte i;
   byte buffer[9];
   byte temp_msb,temp_lsb,temp_half;

   if(touch_present()) {         // get present (reset)
      touch_write_byte(0xCC);    // Skip ROM
      touch_write_byte (0x44);   // Start Conversion
      delay_ms(2000);            // delay 200 ms
      touch_present();           // get present (reset)
      touch_write_byte(0xCC);    // Skip ROM
      touch_write_byte (0xBE);   // Read Scratch Pad

      for(i=0; i<9;i++)          // read 9 bytes
         buffer[i] = touch_read_byte();

      temp_lsb = buffer[0];
      temp_msb = buffer[1];
   }

   printf ("Temperature: %c%3.2f C\r\n", (buffer[1])?'-':' ',
           (float)buffer[0]/2);
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   while(TRUE) {

      ReadTemp_DS1820();
      delay_ms(1000);
   }
}
